package com.yohlj.java.common;

import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

/**
 * @desc 动态获取数据源
 * @author HLJ
 * @date 2018/6/22
 */
public class DynamicDataSource extends AbstractRoutingDataSource {

    /**
     * Determine the current lookup key. This will typically be
     * implemented to check a thread-bound transaction context.
     * <p>Allows for arbitrary keys. The returned key needs
     * to match the stored lookup key type, as resolved by the
     * {@link #resolveSpecifiedLookupKey} method.
     */
    @Override
    protected Object determineCurrentLookupKey() {
        return DataSourceContextHolder.getDataSource();
    }
}
