package com.yohlj.java.common;

/**
 * @author HLJ
 * @desc 当前线程使用的数据源管理器
 * @date 2018/6/22
 */
public class DataSourceContextHolder {

    private static final ThreadLocal<String> holder = new ThreadLocal<>();


    // 设置数据源名
    public static void setDataSource(String name) {
        holder.set(name);
    }

    // 获取数据源名
    public static String getDataSource() {
        return holder.get();
    }

    // 清除数据源名
    public static void removeDataSource() {
        holder.remove();
    }
}
