package com.yohlj.java.common;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.*;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * @desc 动态数据源切面
 * @author HLJ
 * @date 2018/6/22
 */
@Component
@Aspect
@Order(1)
public class DataSourceAspect {

    /**
     * 定义切面
     */
    @Pointcut("execution(* com.yohlj.java.dao.*.*(..))")
    public void pointCut() {

    }

    /**
     * @desc 切换数据源
     * @author HLJ
     * @date 2018/6/22
     * @param point 连接点
     */
    @Before("pointCut()")
    public void switchDataSource(JoinPoint point) {
        // 获取当前访问的 class 的接口列表
        Class<?>[] classArr = point.getTarget().getClass().getInterfaces();
        // 获取当前访问的方法名
        String methodName = point.getSignature().getName();
        // 取得方法参数类型
        Class<?>[] argsClass = ((MethodSignature) point.getSignature()).getMethod().getParameterTypes();
        try {
            // 取得访问的方法对象
            Method method = classArr[0].getMethod(methodName, argsClass);
            // 如果方法使用了 @DataSourceRouter 注解，则使用注解值标识的数据源
            if (method.isAnnotationPresent(DataSourceRouter.class)) {
                String dataSource = method.getAnnotation(DataSourceRouter.class).value();
                DataSourceContextHolder.setDataSource(dataSource);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * @desc 释放数据源
     * @author HLJ
     * @date 2018/6/22
     */
    @After("pointCut()")
    @AfterReturning("pointCut()")
    public void releaseDataSource() {
        DataSourceContextHolder.removeDataSource();
    }

}
